package com.bxm.mcssp.common.entity;

import java.io.Serializable;

import lombok.Data;

/**
 * <p>
 * 广告位的不同类型的配置基类
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-21
 */
@Data
public class PositionConfig implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 图文
     */
    private PositionVideotex positionVideotex;

    /**
     * 图片
     */
    private PositionPicture positionPicture;

    /**
     * 文字
     */
    private PositionText positionText;

    /**
     * 视频
     */
    private PositionVideo positionVideo;

    @Data
    public static class PositionVideotex {
        /**
         * 标题内容最大长度限制
         */
        private Integer titleMaximumLength;

        /**
         * 文本内容限制。{type}-{maximum_len},{type}-{maximum_len}。type：1- 选填、2- 必填，maximum_len：最大长度限制
         */
        private String contentConstraints;

        /**
         * icon尺寸限制。{type-height-width-maximum_kb}。type：1- 选填、2- 必填，height：高，width：宽，maximum_kb：最大KB限制
         */
        private String iconConstraints;

        /**
         * 图片格式：JPG,JPEG,PNG,GIF
         */
        private String pictureFormats;

        /**
         * 图片尺寸约束。{height-width-maximum_kb},{height-width-maximum_kb}。height：高，width：宽，maximum_kb：KB限制
         */
        private String pictureConstraints;
    }

    @Data
    public static class PositionPicture {
        /**
         * 图片格式：JPG,JPEG,PNG,GIF
         */
        private String pictureFormats;

        /**
         * 图片尺寸约束。{height-width-maximum_kb},{height-width-maximum_kb}。height：高，width：宽，maximum_kb：KB限制
         */
        private String pictureConstraints;

        /**
         * (空串代表未填)  标题限制 {type}-{maximum_len},{type}-{maximum_len}。type：1- 选填、2- 必填，maximum_len：最大长度限制
         */
        private String titleConstraints;

        /**
         *  (空串代表未填)  内容限制。{type}-{maximum_len},{type}-{maximum_len}。type：1- 选填、2- 必填，maximum_len：最大长度限制
         */
        private String contentConstraints;
    }

    @Data
    public static class PositionText {
        /**
         * 标题内容最大长度限制
         */
        private Integer titleMaximumLength;

        /**
         * 文本内容限制。{type}-{maximum_len},{type}-{maximum_len}。type：1- 选填、2- 必填，maximum_len：最大长度限制
         */
        private String contentConstraints;
    }

    @Data
    public static class PositionVideo {

        /**
         * 封面图约束 {type-height-width-maximum_kb}。type：1- 选填、2- 必填，height：高，width：宽，maximum_kb：最大KB限制'
         */
        private String coverPictureConstraints;

        /**
         * icon尺寸限制。{type-height-width-maximum_kb}。type：1- 选填、2- 必填，height：高，width：宽，maximum_kb：最大KB限制
         */
        private String iconConstraints;

        /**
         * 大图尺寸限制。{type-height-width-maximum_kb}。type：1- 选填、2- 必填，height：高，width：宽，maximum_kb：最大KB限制'
         */
        private String largeSizeConstraints;

        /**
         * 图片格式：JPG,JPEG,PNG,GIF
         */
        private String pictureFormats;

        /**
         * 标题限制 {type}-{maximum_len},{type}-{maximum_len}。type：1- 选填、2- 必填，maximum_len：最大长度限制'
         */
        private String titleConstraints;


        /**
         * 内容限制。{type}-{maximum_len},{type}-{maximum_len}。type：1- 选填、2- 必填，maximum_len：最大长度限制'
         */
        private String contentConstraints;


        /**
         * 视频尺寸限制 {height-width-maximum_kb}，height：高，width：宽，maximum_kb：最大KB限制
         */
        private String videoSize;

        /**
         * 播放类型 0不限 1 横屏 2 竖屏
         */
        private Integer playType;

        /**
         * 视频格式 存储配置项id 多个以逗号分割
         */
        private String videoFormats;

    }
}
