package com.bxm.mcssp.common.enums.position;

/**
 * <p>
 * 竞价类型：1 CPM，2 CPC，3 CPA
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-17
 */
public enum PositionBiddingTypeEnum {

    /**
     * CPM
     */
    CPM(1, "CPM"),

    /**
     * CPC
     */
    CPC(2, "CPC"),

    /**
     * CPA
     */
    CPA(3, "CPA");

    private Integer type;

    private String desc;

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    PositionBiddingTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static PositionBiddingTypeEnum get(Integer type) {
        if (null == type) {
            return null;
        }
        for (PositionBiddingTypeEnum anEnum : values()) {
            if (anEnum.getType().equals(type)) {
                return anEnum;
            }
        }
        return null;
    }
}
