package com.bxm.mcssp.common.enums.position;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * <p>
 * 广告位场景
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-17
 */
public enum PositionSceneTypeEnum {

    /**
     * 信息流
     */
    INFORMATION_FLOW(1, "信息流", CustomPositionTypeEnum.STANDARD),

    /**
     * 开屏
     */
    BOOT(2, "开屏", CustomPositionTypeEnum.STANDARD),

    /**
     * banner
     */
    BANNER(3, "banner", CustomPositionTypeEnum.STANDARD),

    /**
     * 插屏
     */
    SCREEN(4, "插屏", CustomPositionTypeEnum.STANDARD),

    /**
     * 浮标
     */
    ICON(5, "浮标", CustomPositionTypeEnum.NON_STANDARD),

    /**
     * 按钮
     */
    BUTTON(6, "按钮", CustomPositionTypeEnum.NON_STANDARD),

    /**
     * 搜索
     */
    SEARCH(7, "搜索", CustomPositionTypeEnum.OTHER),

    /**
     * 激励视频
     */
    INSPIRE_VIDEO(8, "激励视频", CustomPositionTypeEnum.STANDARD),

    /**
     * 全屏视频
     */
    VIDEO(9, "全屏视频", CustomPositionTypeEnum.STANDARD),

    /**
     * 自渲染信息流
     * @deprecated
     */
    INFORMATION_FLOW_SELF_RENDERING(11, "自渲染信息流", CustomPositionTypeEnum.OTHER),

    /**
     * 特殊广告位
     */
    SPECIAL_POSITION(12, "特殊广告位", CustomPositionTypeEnum.OTHER),

    /**
     * 自渲染
     */
    SELF_RENDERING(13, "自渲染", CustomPositionTypeEnum.NON_STANDARD),

    /**
     * 沉浸式信息流视频
     */
    INFORMATION_FLOW_IMMERSIVE_VIDEO(14, "沉浸式信息流视频", CustomPositionTypeEnum.STANDARD),

    /**
     * 推送
     */
    PUSH(15, "推送", CustomPositionTypeEnum.NON_STANDARD),

    /**
     * Tab页
     */
    TAB_PAGE(16, "Tab页", CustomPositionTypeEnum.NON_STANDARD),
    ;

    private Integer type;

    private String desc;

    /**
     * 广告位类型（这个是客户化类型）：1 标准广告，2 非标准广告
     */
    private CustomPositionTypeEnum customPositionTypeEnum;

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public CustomPositionTypeEnum getCustomPositionTypeEnum() {
        return customPositionTypeEnum;
    }

    PositionSceneTypeEnum(Integer type, String desc, CustomPositionTypeEnum customPositionTypeEnum) {
        this.type = type;
        this.desc = desc;
        this.customPositionTypeEnum = customPositionTypeEnum;
    }

    public static PositionSceneTypeEnum get(Integer type) {
        if (null == type) {
            return null;
        }
        for (PositionSceneTypeEnum anEnum : values()) {
            if (anEnum.getType().equals(type)) {
                return anEnum;
            }
        }
        return null;
    }

    public static List<Integer> getTypeListByCustomPositionTypeEnum(CustomPositionTypeEnum customPositionTypeEnum) {
        if (null == customPositionTypeEnum) {
            return Collections.emptyList();
        }
        PositionSceneTypeEnum[] values = PositionSceneTypeEnum.values();
        List<Integer> positionTypes = new ArrayList<>(values.length);
        for (PositionSceneTypeEnum positionSceneTypeEnum : values) {
            if (customPositionTypeEnum == positionSceneTypeEnum.getCustomPositionTypeEnum()) {
                positionTypes.add(positionSceneTypeEnum.getType());
            }
            continue;
        }
        return positionTypes;
    }

    /**
     * 获得标准广告位的场景值列表
     * @return
     */
    public static List<Integer> getStandardPosition() {
        return getTypeListByCustomPositionTypeEnum(CustomPositionTypeEnum.STANDARD);
    }

    /**
     * 获得非标准广告位的场景值列表
     * @return
     */
    public static List<Integer> getNonStandardPosition() {
        return getTypeListByCustomPositionTypeEnum(CustomPositionTypeEnum.NON_STANDARD);
    }
}
