package com.bxm.mcssp.common.enums.developer;

/**
 * Description 对账公司code
 *
 * <p>
 * Date 2018/12/26 19:53
 */
public enum AccountCompanyRelationEnum {

    /**
     * 杭州微财公司
     */
    HANGZHOU_WEICAI((byte) 0, "杭州微财网络科技有限公司", "hangzhou_weicai.xls"),


    HUOERGUOSI_BXM((byte) 1, "霍尔果斯变现猫网络科技有限公司", "huoerguosi_bxm.xls"),


    HANGZHOU_BXM((byte) 2, "杭州变现猫网络科技有限公司", "hangzhou_bxm.xls"),

    HAIWAI((byte) 3, "HONG KONG CASHCAT LIMITED", "haiwai.xls");

    /**
     * code , 入库
     */
    private Byte code;

    /**
     * 公司名称
     */
    private String name;

    /**
     * 确认函模板名称
     */
    private String excelName;

    public Byte getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public String getExcelName() {
        return excelName;
    }

    AccountCompanyRelationEnum(Byte code, String name, String excelName) {
        this.code = code;
        this.name = name;
        this.excelName = excelName;
    }

    /**
     * 根据code 返回枚举
     *
     * @param code code
     * @return com.mige.site.enums.AccountCompanyEnum
     */
    public static AccountCompanyRelationEnum getExcelNameByCode(Byte code) {
        if (null == code) {
            return null;
        }
        for (AccountCompanyRelationEnum companyEnum : values()) {
            if (companyEnum.getCode().equals(code)) {
                return companyEnum;
            }
        }
        return null;
    }


}
