package com.bxm.mcssp.common.enums.developer;

/**
 * <p>
 * 开发者预付类型：0 非预付，1 预付
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-17
 */
public enum DeveloperAdvanceTypeEnum {

    /**
     * 非预付
     */
    NO_ADVANCE(0, "非预付"),

    /**
     * 预付
     */
    ADVANCE(1, "预付");

    private Integer type;

    private String desc;

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    DeveloperAdvanceTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }
    
    public static DeveloperAdvanceTypeEnum get(Integer code) {
        if (null == code) {
            return null;
        }
        for (DeveloperAdvanceTypeEnum anEnum : values()) {
            if (anEnum.getType().equals(code)) {
                return anEnum;
            }
        }
        return null;
    }

}
