package com.bxm.mcssp.common.enums.developer;

/**
 * <p>
 * 开发者类型：0 直媒，1 聚合媒体
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-17
 */
public enum DeveloperTypeEnum {

    /**
     * 直媒
     */
    DIRECT_CUSTOMER(0, "直媒"),

    /**
     * 聚合媒体
     */
    PROXY_CUSTOMER(1, "聚合媒体");

    private Integer type;

    private String desc;

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    DeveloperTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }
    
    public static DeveloperTypeEnum get(Integer code) {
        if (null == code) {
            return null;
        }
        for (DeveloperTypeEnum anEnum : values()) {
            if (anEnum.getType().equals(code)) {
                return anEnum;
            }
        }
        return null;
    }

}
