package com.bxm.mcssp.common.util;

import java.util.List;

/**
 * @author 拉拉
 * 内存分页，工具类
 * @time 2019/1/21
 * @CopyRight 杭州微财科技有限公司
 */
public class ListUtil {

    /**
     * @param obj
     * @param listSize
     * @param startNum
     * @param endNum
     * @return java.util.List<T>
     * 内存分页
     * @author 拉拉
     * @time 2019/1/21
     * @CopyRight 杭州微财科技有限公司
     */
    public static <T> List<T> getTotalPage(List<T> obj, int listSize, int startNum, int endNum) {
        // 总的页数
        int pageCount = 0;
        /* 计算出总共能分成多少页 */
        if (listSize % endNum > 0) // 数据总数和每页显示的总数不能整除的情况
        {
            pageCount = listSize / endNum + 1;
        } else // 数据总数和每页显示的总数能整除的情况
        {
            pageCount = listSize / endNum;
        }
        if (listSize > 0) {
            if (startNum <= pageCount) {
                if (startNum == 1) // 当前页数为第一页
                {
                    if (listSize <= endNum) // 数据总数小于每页显示的数据条数
                    {
                        // 截止到总的数据条数(当前数据不足一页，按一页显示)，这样才不会出现数组越界异常
                        obj = obj.subList(0, listSize);
                    } else {
                        obj = obj.subList(0, endNum);
                    }
                } else {
                    // 截取起始下标
                    int fromIndex = (startNum - 1) * endNum;
                    // 截取截止下标
                    int toIndex = startNum * endNum;
                    /* 计算截取截止下标 */
                    if ((listSize - toIndex) % endNum >= 0) {
                        toIndex = startNum * endNum;
                    } else {
                        toIndex = (startNum - 1) * endNum + (listSize % endNum);
                    }
                    if (listSize >= toIndex) {
                        obj = obj.subList(fromIndex, toIndex);
                    }
                }
            } else {
                obj = null;
            }
        }
        return obj;
    }

}
