package com.bxm.mcssp.common.enums.app;

/**
 * <p>
 * 审核类型：1 先投后审，2 先审后投
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-17
 */
public enum AppAuditTypeEnum {

    /**
     * 先投后审
     */
    PASS( 1, "先投后审"),

    /**
     * 先审后投
     */
    WAIT_AUDIT(2, "先审后投");

    private Integer type;

    private String desc;

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    AppAuditTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static AppAuditTypeEnum get(Integer type) {
        if (null == type) {
            return null;
        }
        for (AppAuditTypeEnum anEnum : values()) {
            if (anEnum.getType().equals(type)) {
                return anEnum;
            }
        }
        return null;
    }

}
