package com.bxm.mcssp.common.enums.position;

/**
 * <p>
 * 变现方式：1 标准广告变现，2 组件变现
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-17
 */
public enum PositionMonetizedTypeEnum {

    /**
     * 标准广告变现
     */
    BENCHMARK_MONETIZE(1, "标准广告变现"),

    /**
     * 组件变现
     */
    ASSEMBLY_MONETIZE(2, "组件变现");

    private Integer type;

    private String desc;

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    PositionMonetizedTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static PositionMonetizedTypeEnum get(Integer type) {
        if (null == type) {
            return null;
        }
        for (PositionMonetizedTypeEnum anEnum : values()) {
            if (anEnum.getType().equals(type)) {
                return anEnum;
            }
        }
        return null;
    }
}
