package com.bxm.mcssp.facade.model.position;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

import com.fasterxml.jackson.annotation.JsonFormat;

import lombok.Data;
import lombok.ToString;

/**
 * <p>
 * 广告位待审核列表
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-17
 */
@Data
@ToString
public class PositionAuditFacadeVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 开发者ID
     */
    private Long developerId;

    /**
     * 应用ID
     */
    private Long appId;

    /**
     * 广告位id标识
     */
    private String positionId;

    /**
     * 广告位名称
     */
    private String positionName;

    /**
     * 广告位类型：1 图文，2 图片，3 文字，4 视频
     */
    private Integer positionType;

    /**
     * 变现方式：1 标准广告变现，2 组件变现
     */
    private Integer monetizedType;

    /**
     * app开发者申请的key
     */
    private String appKey;

    /**
     * 对接类型：1 API，2 SDK
     */
    private Integer dockingMethodType;

    /**
     * 广告位截图
     */
    private String positionPicUrl;

    /**
     * 创意格式
     */
    private String creativeFormats;

    /**
     * 广告位场景：1 开屏，2 互动
     */
    private Integer positionScene;

    /**
     * 信息流模板
     */
    private Integer informationFlowTemplate;

    /**
     * 平台类型：1 IOS，2 安卓，3 H5，4 PC
     */
    private Integer platformType;

    /**
     * 广告位尺寸：长*宽
     */
    private String positionSize;

    /**
     * 合作类型： 1 分成，2 竞价，3 包段
     */
    private Integer cooperationType;

    /**
     * 分成比例
     */
    private BigDecimal divideInto;

    /**
     * 竞价类型：1 CPM，2 CPC，3 CPA
     */
    private Integer biddingType;

    /**
     * 价格，合作类型为竞价时单位为 元/CPM，合作类型为包段时单位为 元/天
     */
    private BigDecimal basePrice;

    /**
     * 包段开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private LocalDate startDate;

    /**
     * 包段结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private LocalDate endDate;

    /**
     * 预估请求量
     */
    private Long predictRequestNum;

    /**
     * 预估点击率
     */
    private BigDecimal predictClickRate;

    /**
     * 创意审核托管：1 委托，0 不委托
     */
    private Integer isEntrustCreativeAudit;

    /**
     * 支持的广告位类型：1 落地页，2 下载类，3 Deeplink类
     */
    private String supportPositionType;

    /**
     * 媒体端广告位ID
     */
    private String appPositionId;

    /**
     * 审核状态：0 风控终审，1 终审通过，2 终审拒绝，3 媒介初审，4 初审拒绝
     */
    private Integer status;

    /**
     * 审核拒绝配置ID，多个拒绝原因用逗号分隔
     */
    private String reviewRefuseIds;

    /**
     * 拒绝原因
     */
    private String refuseReason;

    /**
     * 备注
     */
    private String remark;

    /**
     * 是否已关闭：1 表示已关闭，0 表示未关闭
     */
    private Integer closedFlag;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime createTime;



    //额外的信息
    //开发者相关数据

    /**
     * 开发者名称
     */
    private String developerName;
    /**
     * 开发者别名
     */
    private String developerAlias;
    /**
     * 开发者公司名称
     */
    private String companyName;

    /**
     * 媒体运营
     */
    private String mjCode;
    private String mjName;

    /**
     * 商务BD
     */
    private String bdCode;
    private String bdName;


    //应用相关数据
    /**
     * 应用名称
     */
    private String appName;
}
