package com.bxm.mcssp.facade.service;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.mcssp.facade.constant.Constants;
import com.bxm.mcssp.facade.model.position.sdkconfig.PositionSdkConfigFacadeDTO;
import com.bxm.mcssp.facade.model.position.sdkconfig.PositionSdkConfigFacadeQueryDTO;
import com.bxm.mcssp.facade.model.position.sdkconfig.PositionSdkConfigFacadeVO;

/**
 * <p>
 * 广告位SDK配置 feign client 服务
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-1-7
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface PositionSdkConfigFacadeService {

    /**
     * 保存配置
     * @param positionSdkConfigFacadeDTO
     * @return
     */
    @RequestMapping(value = "/facade/positionsdkconfig/addConfig", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> addConfig(@RequestBody PositionSdkConfigFacadeDTO positionSdkConfigFacadeDTO);

    /**
     * 根据 positionId 获取配置 List
     * @param positionId
     * @return
     */
    @RequestMapping(value = "/facade/positionsdkconfig/getConfigList", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<List<PositionSdkConfigFacadeVO>> getConfigList(@RequestParam("positionId") String positionId);

    /**
     * 同步广告位初始化数据，为每一个广告位添加默认的变现猫渠道
     * @param bxmTypeId
     */
    @RequestMapping(value = "/facade/positionsdkconfig/syncDefaultPositionSdkConfig", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> syncDefaultPositionSdkConfig(@RequestParam("bxmTypeId") String bxmTypeId);

    /**
     * 同步广告位初始化数据，为每一个广告位(激励视频场景)添加默认的变现猫兜底渠道
     */
    @RequestMapping(value = "/facade/positionsdkconfig/syncDefaultBackupPositionSdkConfig", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> syncDefaultBackupPositionSdkConfig();

    /**
     * 同步推送所有广告位，广告位配置数据
     */
    @RequestMapping(value = "/facade/positionsdkconfig/pushAllPositionSdkConfig", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> pushAllPositionSdkConfig();


    /**
     * 分页查询
     *
     * @param dto 查询参数
     * @return
     */
    @RequestMapping(value = "/facade/positionsdkconfig/page", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Page<PositionSdkConfigFacadeVO>> page(@RequestBody PositionSdkConfigFacadeQueryDTO dto);

    /**
     * 列表
     *
     * @param dto 查询条件
     * @return
     */
    @RequestMapping(value = "/facade/positionsdkconfig/getList", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<List<PositionSdkConfigFacadeVO>> getList(@RequestBody PositionSdkConfigFacadeQueryDTO dto);
}
