package com.bxm.mcssp.facade.service;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.bxm.mcssp.facade.constant.Constants;

/**
 * <p>
 * 站内信 feign client 服务
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-18
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface StationMsgFacadeService {

    /**
     * 发送站内消息
     *
     * @param sender     发送者
     * @param receiverId 接收者 （开发者ID,为0是发送给所有人）
     * @param subject    主题
     * @param context    内容
     * @return
     */
    @RequestMapping(value = "/facade/stationMsg/send", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> send(@RequestParam(name = "sender") String sender,
                                 @RequestParam(name = "receiverId") Long receiverId,
                                 @RequestParam(name = "subject") String subject,
                                 @RequestParam(name = "context") String context);


}
