package com.bxm.mcssp.facade.model.developer;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 开发者
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-18
 */
@Data
@ToString
public class DeveloperFacadeVO extends DeveloperBaseVO implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    /**
     * 手机号码
     */
    private String phoneNum;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 开发者名称
     */
    private String developerName;

    /**
     * 开发者别名
     */
    private String developerAlias;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * app_key
     */
    private String appKey;

    /**
     * 联系人名称
     */
    private String contacts;

    /**
     * 预付类型：0 非预付，1 预付
     */
    private Integer advanceType;

    /**
     * 开发者类型：0 直媒，1 聚合媒体
     */
    private Integer developerType;

    /**
     * 媒体运营
     */
    private String mjCode;

    /**
     * 商务BD
     */
    private String bdCode;

    /**
     * 提交审核通过标识：0 未通过，1 已通过
     * 针对老数据：开发者下有上线的广告位，则为已提交
     * 这个字段的用途是用来判断开发者是否需要走注册引导页面，0走，1不走
     */
    private Integer reviewFlag;

    /**
     * 提交审核时间
     * 这个字段的用途是用来联合reviewFlag为未提交（0）时使用，
     * 如果有提交时间，则说明提交过，没有则没有提交。
     * 运营管理后台-开发者分配页面需要显示 review_flag = 1 and (reviewFlag=0 and submitReviewDate is not null )的数据
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime submitReviewDate;

    /**
     * 最后登录的IP地址
     */
    private String lastLoginIp;

    /**
     * 开发者标签，多个标签用逗号分隔
     */
    private String tags;

    /**
     * 财务结算单对应的公司主体Code
     */
    private Integer accountCompanyRelationCode;

    /**
     * 应用数量
     */
    private Integer appCount;

    /**
     * 广告位数量
     */
    private Integer positionCount;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime createTime;

    /**
     * 修改人
     */
    private String modifyUser;

    /**
     * 修改时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime modifyTime;

    /**
     * 区域  0：国内 1：海外
     */
    private Integer areaType;

    //额外的信息

}
