package com.bxm.mcssp.facade.model.app;

import java.io.Serializable;
import java.time.LocalDateTime;

import com.bxm.mcssp.facade.model.PageDTO;

import lombok.Data;
import lombok.ToString;

/**
 * <p>
 * 编辑,查询开发者
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-17
 */
@Data
@ToString
public class AppFacadeDTO extends PageDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 开发者ID
     */
    private Long developerId;

    /**
     * AppID
     */
    private String appId;

    /**
     * 应用名称
     */
    private String appName;

    /**
     * 平台类型：1 IOS，2 安卓，3 H5，4 PC
     */
    private Integer platformType;

    /**
     * 应用分类
     */
    private String appClass;

    /**
     * 应用子分类
     */
    private String appChildClass;

    /**
     * 广告喜好类别，多个类型用逗号分隔
     */
    private String adPreference;

    /**
     * 应用包名
     */
    private String appPackageName;

    /**
     * 应用下载地址
     */
    private String appDownloadUrl;

    /**
     * 审核类型：1 先投后审，2 先审后投
     */
    private Integer auditType;

    /**
     * 对接类型：1 API，2 SDK
     */
    private Integer dockingMethodType;

    /**
     * 应用简介
     */
    private String appDesc;

    /**
     * 审核状态：0 风控终审，1 终审通过，2 终审拒绝，3 媒介初审，4 初审拒绝
     */
    private Integer status;

    /**
     * 广告位数量
     */
    private Integer positionCount;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 修改人
     */
    private String modifyUser;

    /**
     * 修改时间
     */
    private LocalDateTime modifyTime;

    /**
     * 是否开启耍呗：1-开启，0-关闭
     */
    private Integer flourished;

    /**
     * 国家代号，多个逗号分隔
     */
    private String country;

    /**
     * 支持广告类型 1、全行业 2、仅商品上架产品
     */
    private Integer adSupportType;

    //额外的信息


}
