package com.bxm.mcssp.facade.model.developer;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 开发者分配列表
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-17
 */
@Data
@ToString
public class DeveloperAssignmentFacadeVO extends DeveloperBaseVO implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    /**
     * 提交审核时间
     * 开发者名称
     * 邮箱
     * 财务状态
     * 应用状态
     * 广告位状态
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime submitReviewDate;
    private String developerName;
    private String email;

    private Integer financeStatus;
    private String appStatus;
    private String positionStatus;

    /**
     * 对接类型：1 API，2 SDK
     * @see com.bxm.mcssp.common.enums.app.DockingMethodTypeEnum
     */
    private Integer dockingMethodType;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 是否可是老数据
     */
    private boolean oldData;

    /**
     * 是否可修改对接方式
     */
    private boolean dockingMethodTypeEdit;

    /**
     * 是否可操作编辑
     */
    private boolean operatorEdit;

    /**
     * 是否可操作标签
     */
    private boolean operatorTag;

    /**
     * 是否可操作审核
     */
    private boolean operatorAudit;

    /**
     * 区域类型  0：国内  1：海外
     */
    private Integer areaType;

    /**
     * 财务信息创建人
     */
    private String financeCreateUser;

    /**
     * 是否为跳过财务信息
     */
    private Boolean skipFinance;

    /**
     * 底价查看权限0：隐藏 1：显示
     */
    private Integer floorPricePermission;

}
