package com.bxm.mcssp.facade.model.developer;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 审核开发者列表
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-17
 */
@Data
@ToString
public class DeveloperFinanceListFacadeVO extends DeveloperBaseVO implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    /**
     * appKey
     * 邮箱
     * 手机号
     * 公司名称
     * 联系人名称
     * 开发者类型， 0：直客， 1：代理
     * 开发者名称
     * 开发者别名
     * 媒介code
     * 商务code
     * 创建时间
     * 备注
     */
    private String appKey;
    private String email;
    private String phoneNum;
    private String companyName;
    private String contacts;
    private Integer developerType;
    private String developerName;
    private String developerAlias;
    private String mjCode;
    private String mjName;
    private String bdCode;
    private String bdName;
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private LocalDateTime createTime;

    /**
     * 营业执照号
     * 营业执照图片
     * 开业许可证图片
     * 开户银行名称
     * 支行名称
     * 开户名
     * 账号
     * 审核状态
     * 拒绝原因
     */
    private String licenseNo;
    private String licensePicUrl;
    private String openingPermitPicUrl;
    private String bankName;
    private String bankBranchName;
    private String accountName;
    private String accountNumber;
    private Integer status;
    private String refuseReason;
    /**
     * 区域类型  0：国内  1：海外
     */
    private Integer areaType;

    /**
     * 海外账户swift code
     */
    private String swiftCode;

    /**
     * 收款公司地址
     */
    private String companyAddress;

    /**
     * 收款银行地址
     */
    private String bankAddress;
}
