package com.bxm.mcssp.facade.service;

import java.util.List;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.bxm.mcssp.common.entity.IDAndNameVO;
import com.bxm.mcssp.facade.constant.Constants;

/**
 * <p>
 * 广告位集合 feign client 服务
 * </p>
 *
 * @author zhengwangeng
 * @since 2021-9-22
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface PositionCollectionFacadeService {

    /**
     * 获取子广告位列表
     *
     * @param positionId 广告位ID
     * @return
     */
    @RequestMapping(value = "/facade/positioncollection/list", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<List<IDAndNameVO>> list(@RequestParam(value = "positionId") String positionId);

}
