package com.bxm.mcssp.facade.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.mcssp.common.entity.IDAndNameVO;
import com.bxm.mcssp.facade.constant.Constants;
import com.bxm.mcssp.facade.model.app.AppFacadeDTO;
import com.bxm.mcssp.facade.model.app.AppFacadeQueryDTO;
import com.bxm.mcssp.facade.model.app.AppFacadeVO;
import com.bxm.mcssp.facade.model.app.AppWaitingAuditFacadeVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * <p>
 * 应用 feign client 服务
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-18
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface AppFacadeService {

    /**
     * ID和名称数据，主要用于下拉框填充
     *
     * @param keyword 查询参数
     * @return
     */
    @RequestMapping(value = "/facade/app/common/list", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<List<IDAndNameVO>> list(@RequestParam(value = "keyword", required = false) String keyword);

    /**
     * 分页查询
     *
     * @param dto 查询参数
     * @return
     */
    @RequestMapping(value = "/facade/app/page", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Page<AppFacadeVO>> page(@RequestBody AppFacadeQueryDTO dto);

    /**
     * 根据id查询
     *
     * @param id id
     * @return
     */
    @RequestMapping(value = "/facade/app/get", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<AppFacadeVO> get(@RequestParam(value = "id") Long id);

    /**
     * 修改
     *
     * @param dto 修改参数
     * @return
     */
    @RequestMapping(value = "/facade/app/update", method = RequestMethod.POST, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> update(@RequestBody AppFacadeDTO dto);


    /**
     * 运营后台查询审核页面的 应用列表
     *
     * @param developerKeyword 公司名称
     * @param appKeyword   应用名称
     * @param status      状态 0待审核， 1审核通过， 2审核拒绝
     * @param mjCode      媒介code
     * @param current     页码
     * @param size    页面大小
     * @return
     */
    @RequestMapping(value = "/facade/app/getAuditPage", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Page<AppWaitingAuditFacadeVO>> getAuditPage(@RequestParam(name = "developerKeyword", required = false) String developerKeyword,
                                                               @RequestParam(name = "appKeyword", required = false) String appKeyword,
                                                               @RequestParam(name = "status", required = false) Integer status,
                                                               @RequestParam(name = "developerId", required = false, defaultValue = "-1") Long developerId,
                                                               @RequestParam(name = "mjCode", required = false) String mjCode,
                                                               @RequestParam(name = "current", defaultValue = "1") Integer current,
                                                               @RequestParam(name = "size", defaultValue = "20") Integer size,
                                                               @RequestParam(name = "areaType") Integer areaType);

    /**
     * 审核应用
     *
     * @param id           应用id
     * @param auditPass    审核通过
     * @param isMJ         是否是媒介审核
     * @param refuseReason 拒绝原因
     * @param reviewRefuseIds 拒绝原因ID列表
     * @param modifyUser     审核人
     * @return
     */
    @RequestMapping(value = "/facade/app/audit", method = RequestMethod.GET, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> audit(@RequestParam("id") Long id,
                               @RequestParam("auditPass") Boolean auditPass,
                               @RequestParam("isMJ") Boolean isMJ,
                               @RequestParam("refuseReason") String refuseReason,
                               @RequestParam("reviewRefuseIds") String reviewRefuseIds,
                               @RequestParam("modifyUser") String modifyUser);


}
