package com.bxm.mcssp.facade.service;

import com.bxm.mcssp.facade.constant.Constants;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @author pf.w
 * @date 2023/2/9 19:19
 */
@FeignClient(name = Constants.SERVER_NAME)
public interface AppNewFacadeService {
    /**
     * 根据应用分类获取应用id列表
     * @param appClass
     * @param appChildClass
     * @return
     */
    @RequestMapping(value = "/facade/app/list", method = RequestMethod.GET, consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<List<String>> getPositionId(@RequestParam(value = "appClass", required = false) String appClass,
                                               @RequestParam(value = "appChildClass", required = false) String appChildClass);

    /**
     *根据应该id  获取应用分类描述
     * @param sspAppIdsStr
     * @return Map<KEY(应用ID),VALUE(分类描述)>
     */
    @RequestMapping(value = "/facade/app/map", method = RequestMethod.GET, consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Map<String,String>> getAppTypeName(@RequestParam(value="sspAppIdsStr",required = true) String sspAppIdsStr);
}
