package com.bxm.messager.facade.dto;

import com.bxm.messager.facade.enums.ChannelEnum;
import lombok.Builder;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 *
 * 获取消息列表上行参数
 *
 * @author pf.w
 * @date 2021/8/18 11:49
 **/
@Data
@Builder
public class MessageListInfoDTO extends PageParam implements Serializable {

    private static final long serialVersionUID = 1L;


    /**
     * 广告主 或者 媒体 渠道ID
     */
    @NotNull(message = "主体id不能为空")
    private Long channelId;

    /**
     * 主体类型 1:广告主 | 0:媒体
     */
    @NotNull(message = "渠道描述不能为空")
    private Integer channel;

    /**
     * 已读 未读     0：未读  1：已读
     */
    private Integer readFlag;

    /**
     * 发件人  0：系统消息  1：推送消息
     */
    private Integer sender;

    /**
     * 主体渠道名称
     */
    private String providerName;
}
