package com.bxm.messager.facade.service;

import com.bxm.messager.facade.bo.PageBO;
import com.bxm.messager.facade.dto.MessageInfoDTO;
import com.bxm.messager.facade.dto.MessageListInfoDTO;
import com.bxm.messager.facade.enums.ChannelEnum;
import com.bxm.messager.facade.enums.MessageOperateEnum;
import com.bxm.messager.facade.vo.MessageInfoListVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 *
 * 提供消息展示列表接口；发送消息接口
 *
 *
 * @author pf.w
 * @date 2021/8/18 11:21
 **/
@FeignClient(name = "MESSAGER")
public interface MessageInfoServiceFacade {


    /**
     * 获取消息列表
     *
     * @param param 设置不同的请求主体
     * @return 消息列表集合
     */
    @GetMapping(value = "/facade/getMessageList",consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<PageBO<MessageInfoListVO>> messageList(@Valid MessageListInfoDTO param);


    /**
     *
     * 设置推送内部消息
     *
     * @param param 消息内容  注意看param备注信息 不要遗漏字段
     * @return true成功
     */
    @PostMapping(value = "/facade/pushMessage",consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> pushMessage(@RequestBody MessageInfoDTO param);

    /**
     *
     * 消息操作接口  目前只有设置已读未读状态
     *
     * @param messageId 消息id
     * @param operateType 动作类型 1: 已读
     * @param channel 主体类型  1：广告主 | 0：媒体
     * @param subjectId  主体ID  广告主ID | 媒体 ID
     * @return true 成功
     */
    @PostMapping(value = "facade/messageOperate",consumes = MediaType.APPLICATION_JSON_UTF8_VALUE)
    ResponseEntity<Boolean> messageOperate(@RequestParam("messageId") Long messageId, @RequestParam("operate") Integer operateType,
                                           @RequestParam Integer channel,@RequestParam("subjectId") Long subjectId);
}
