package com.bxm.messager.facade.vo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 *
 * 消息列表数据实体
 *
 * @author pf.w
 * @date 2021/8/18 11:43
 **/
@Data
public class MessageInfoListVO implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long id;

    /**
     * 发件人  系统通知 | 推送消息
     */
    private String sender;

    @JsonIgnore
    private Integer pushGoalType;

    /**
     * 标题
     */
    private String title;

    /**
     * 推送类型描述（名称）
     */
    private String pushTopicDesc;

    /**
     * 收件人类型描述 媒体 | 广告主
     */
    private String pushGoalDesc;

    /**
     * 推送时间
     */
    private Date pushDataTime;

    /**
     * 推送正文 富文本内容
     */
    private String pushContent;

    /**
     * 已读未读状态  0：未读  1：已读
     */
    private Integer readFlag;
}
