package com.bxm.messager.facade.dto;

import com.bxm.messager.facade.enums.ChannelEnum;
import com.bxm.messager.facade.enums.MessagePushTopicTypeEnum;
import com.bxm.messager.facade.enums.PushStatusEnum;
import lombok.Builder;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
 *
 * 创建消息数据实体
 *
 * @author pf.w
 * @date 2021/8/18 13:50
 **/
@Data
@Builder
public class MessageInfoDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 标题
     */
    @NotNull
    private String title;

    /**
     * 推送类型 0：活动  1：处罚公示 2：政策通知  3：客情维护  4：节日通知 5:系统通知
     */
    @NotNull
    private Integer pushTopicType;

    /**
     * 推送对象类型 0：媒体   1：广告主
     */
    @NotNull
    private Integer channel;

    /**
     * 推送对象收件人类型   0：全员  1：指定用户
     */
    @NotNull
    private Integer pushGoalUserType;

    /**
     * 当为指定用户发送时  id用","逗号隔开  比如广告主id  11001,11002,11003
     */
    private String pushGoalUserContent;

    /**
     * 推送正文 富文本内容
     */
    @NotNull
    private String pushContent;

    /**
     * 推送消息状态  0：待发送   1：立刻发送
     */
    @NotNull
    private Integer pushStatus;

    /**
     * 推送时间  如果待发送状态该字段不能为空 精确到秒
     */
    private Date pushDataTime;

    /**
     * 创建人  方便追溯 请设置该消息的创建人  比如开发者姓名拼音:   LiuDeHua
     */
    @NotNull
    private String createUser;
}
