/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.monitor.service.cheat;

import com.alibaba.dubbo.config.annotation.Service;
import com.bxm.monitor.dal.anticheat.AppErrorSignDetailMapper;
import com.bxm.monitor.facade.cheat.CountInfoMonitorService;
import com.bxm.monitor.facade.cheat.MonitorInfo;
import com.bxm.monitor.model.dao.AppErrorSignDetail;
import com.bxm.monitor.service.commons.RedisClient;
import com.bxm.monitor.service.constant.MonitorRedisConstant;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;
import org.jsoup.helper.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0")
public class CountInfoMonitorServiceImpl
implements CountInfoMonitorService {
    private static final Logger LOG = Logger.getLogger(CountInfoMonitorServiceImpl.class);
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private AppErrorSignDetailMapper appErrorSignDetailMapper;
    private static final long URL_EFFECTIVE_TIME = 60000L;
    private static final String NO_SIGN = "\u63a5\u53e3\u8bf7\u6c42\u6ca1\u6709\u7b7e\u540d";
    private static final String NO_TIMESTAMP = "\u63a5\u53e3\u8bf7\u6c42\u6ca1\u6709\u65f6\u95f4\u6233";
    private static final String TIMESTAMP_TIMEOUT = "\u63a5\u53e3\u8bf7\u6c42\u65f6\u95f4\u6233\u5927\u4e8e\u5f53\u524d\u65f6\u95f41\u5206\u949f";
    private static final String ERROR_SIGN = "\u63a5\u53e3\u8bf7\u6c42\u7b7e\u540d\u9519\u8bef";

    public void verifyClientDevice(MonitorInfo monitorInfo) {
        boolean isMobile = true;
        isMobile = StringUtil.isBlank((String)monitorInfo.getUserAgent()) ? false : this.isMobileDevice(monitorInfo.getUserAgent());
        if (!isMobile) {
            String errorOsKey = MonitorRedisConstant.connectRedisKey("dting", "errorrUserAgent", "datetime", monitorInfo.getDateTime(), "appkey", monitorInfo.getAppKey(), "business", monitorInfo.getBusiness(), "preid", monitorInfo.getTicketId(), "userAgent", monitorInfo.getUserAgent());
            this.redisClient.incrWithDb(errorOsKey, MonitorRedisConstant.DBINDEX);
            this.redisClient.sAddWithDb(MonitorRedisConstant.connectRedisKey("dting", "set:errorUserAgent"), errorOsKey, MonitorRedisConstant.DBINDEX);
        }
    }

    public void verifyUrlOrigin(MonitorInfo monitorInfo) {
        boolean isErrorOrigin = false;
        if (StringUtil.isBlank((String)monitorInfo.getOrigin())) {
            monitorInfo.setOrigin("unknown");
            isErrorOrigin = true;
        } else if ("http://buy.bianxianmao.com,https://buy.bianxianmao.com,http://live.bianxianmao.com,https://live.bianxianmao.com,http://joke.bianxianmao.com,https://joke.bianxianmao.com,http://jifen.bianxianmao.com,https://jifen.bianxianmao.com,http://fuli.bianxianmao.com,https://fuli.bianxianmao.com,http://m.cudaojia.com,https://m.cudaojia.com,http://buyimg.bianxianmao.com,https://buyimg.bianxianmao.com,http://pc.tandehao.com,https://pc.tandehao.com,http://tst.bianxianmao.com,https://tst.bianxianmao.com,http://wap.n.v5fans.com,https://wap.n.v5fans.com".indexOf(monitorInfo.getOrigin()) == -1) {
            isErrorOrigin = true;
        }
        if (isErrorOrigin) {
            String errorOriginKey = MonitorRedisConstant.connectRedisKey("dting", "errorOrigin", "datetime", monitorInfo.getDateTime(), "appkey", monitorInfo.getAppKey(), "business", monitorInfo.getBusiness(), "preid", monitorInfo.getTicketId(), "origin", monitorInfo.getOrigin());
            this.redisClient.incrWithDb(errorOriginKey, MonitorRedisConstant.DBINDEX);
            this.redisClient.sAddWithDb(MonitorRedisConstant.connectRedisKey("dting", "set:errorOrigin"), errorOriginKey, MonitorRedisConstant.DBINDEX);
        }
    }

    public void verifySignStamp(MonitorInfo monitorInfo) {
        String result = this.verifySign(monitorInfo.getSign(), monitorInfo.getTimestamp(), monitorInfo.getAppKey(), monitorInfo.getActivityId(), monitorInfo.getBusiness(), monitorInfo.getTicketId(), monitorInfo.getParametersSign());
        if (result != null) {
            String errorSignKey = MonitorRedisConstant.connectRedisKey("dting", "errorSign", "datetime", monitorInfo.getDateTime(), "appkey", monitorInfo.getAppKey(), "business", monitorInfo.getBusiness(), "preid", monitorInfo.getTicketId(), "remark", result);
            this.redisClient.incrWithDb(errorSignKey, MonitorRedisConstant.DBINDEX);
            this.redisClient.sAddWithDb(MonitorRedisConstant.connectRedisKey("dting", "set:errorSign"), errorSignKey, MonitorRedisConstant.DBINDEX);
        }
    }

    private String verifySign(String sign, String timeStamp, String appKey, Long acivityId, String business, Long preid, String paramters) {
        if (null == sign) {
            return NO_SIGN;
        }
        if (null == timeStamp) {
            return NO_TIMESTAMP;
        }
        long now = System.currentTimeMillis();
        if (now - Long.valueOf(timeStamp) > 60000L) {
            return TIMESTAMP_TIMEOUT;
        }
        try {
            String mySign = DigestUtils.md5Hex((byte[])paramters.getBytes("UTF-8"));
            if (!sign.equals(mySign)) {
                AppErrorSignDetail appErrorSignDetail = new AppErrorSignDetail();
                appErrorSignDetail.setAppKey(appKey);
                appErrorSignDetail.setActivityId(Integer.valueOf(null == acivityId ? acivityId.intValue() : 0));
                appErrorSignDetail.setBusiness(business);
                appErrorSignDetail.setPreid(preid + "");
                appErrorSignDetail.setMySign(mySign);
                appErrorSignDetail.setAppErrorSign(sign);
                this.appErrorSignDetailMapper.insertErrorSign(appErrorSignDetail);
                return ERROR_SIGN;
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)"verifySign error===");
            e.printStackTrace();
        }
        return null;
    }

    private boolean isMobileDevice(String userAgent) {
        if (null == userAgent) {
            return false;
        }
        String[] deviceArray = new String[]{"android", "iphone", "ipad", "ipod", "windows phone", "symbianos", "blackberry", "windows mobile"};
        userAgent = userAgent.toLowerCase();
        for (int i = 0; i < deviceArray.length; ++i) {
            if (userAgent.indexOf(deviceArray[i]) == -1) continue;
            return true;
        }
        return false;
    }
}

