/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.monitor.service.commons;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Component
public class RedisClient {
    private static final Logger LOG = Logger.getLogger(RedisClient.class);
    @Autowired
    @Qualifier(value="jedisPool")
    private JedisPool jedisPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long sAddWithDb(String key, String value, Integer dbIndex) {
        if (null == key) {
            return null;
        }
        Jedis jedis = null;
        Long result = null;
        try {
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            result = jedis.sadd(key, new String[]{value});
        }
        catch (Exception e) {
            LOG.error((Object)"sAdd ERROR", (Throwable)e);
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long incrWithDb(String key, Integer dbIndex) {
        if (null == key) {
            return null;
        }
        Long result = null;
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (dbIndex != null) {
                jedis.select(dbIndex.intValue());
            }
            result = jedis.incr(key);
        }
        return result;
    }
}

