package com.bxm.monitor.util.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Random;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.jsoup.helper.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.bxm.monitor.util.commons.RedisClientByCode;
import com.bxm.monitor.util.constant.MonitorRedisConstant;
import com.bxm.monitor.util.model.ValidateImgInfo;
import com.bxm.monitor.util.service.CodeValidateImgService;
import com.bxm.warcar.utils.HttpUtils;

/**
 * 类CodeValidateImgServiceImpl.java的实现描述：TODO 类实现描述
 * 
 * @author 拉拉 2018年8月29日 下午4:31:36
 */
@Service
public class CodeValidateImgServiceImpl implements CodeValidateImgService {

    @Autowired
    private RedisClientByCode redisClient;

    @Override
    public Boolean isCodeValidateImg(HttpServletRequest request) {
        // 从refer获取 spm的值
        String spm = getSpmByRefer(request);
        // 如果没有spm的用户，都不弹验证码
        if (StringUtils.isBlank(spm)) {
            return false;
        }
        // 获取IP地址
        String ipAddress = HttpUtils.getIpFromHeader(request);
        // 作弊ip的key
        String ipKey = MonitorRedisConstant.connectRedisKey(MonitorRedisConstant.redisKey, MonitorRedisConstant.cheatIP,
                                                            ipAddress);
        // 作弊ip下面的具体的流水号（spm）的key
        String spmKey = MonitorRedisConstant.connectRedisKey(MonitorRedisConstant.redisKey,
                                                             MonitorRedisConstant.cheatSPM, spm);
        // 第一步，判断是否是手机浏览器登录（根据useragent）非手机浏览器也只是第一次进来谈验证码
        // 获取User-Agent
        String userAgent = request.getHeader("User-Agent");
        if (StringUtil.isBlank(userAgent)) {
            // 根据用户流水号判断是不是当天第一次来
            return isFirst(spmKey);
        } else {
            if (!isMobileDevice(userAgent)) {
                // 根据用户流水号判断是不是当天第一次来
                return isFirst(spmKey);
            }
        }

        String value = redisClient.get(ipKey, MonitorRedisConstant.DBINDEX);
        // 不等于空，代表是作弊ip
        if (StringUtils.isNotEmpty(value)) {
            return isFirst(spmKey);
        }

        return false;
    }

    public Boolean isFirst(String spmKey) {
        // 根据用户流水号判断是不是当天第一次来
        String isFirstValue = redisClient.get(spmKey, MonitorRedisConstant.DBINDEX);
        // 假如用户不是第一次来，那么不弹验证码,10000代表验证通过,反之是出验证码了，但是没有验证通过
        if (StringUtils.equalsIgnoreCase("10000", isFirstValue)) {
            return false;
        } else {
            // 如果已经有值，并且不是1代表已经出了验证码（考虑到并发问题）
            if (!StringUtils.equalsIgnoreCase("1", isFirstValue)) {
                redisClient.setWithTimeAndDB(spmKey, "1", MonitorRedisConstant.EXPIRY_TIME,
                                             MonitorRedisConstant.DBINDEX);
            }
        }
        return true;
    }

    /**
     * @description: 随机获取验证码
     * @param
     * @return
     */
    public ValidateImgInfo getValidateImgInfo(HttpServletRequest request) {
        ValidateImgInfo vi = new ValidateImgInfo();
        Random random = new Random();
        int templateNo = random.nextInt(MonitorRedisConstant.img.length);
        String[] img = MonitorRedisConstant.img[templateNo].split(",");
        vi.setImg1(MonitorRedisConstant.codeUrl + img[0]);
        vi.setImg2(MonitorRedisConstant.codeUrl + img[1]);
        vi.setMove(Integer.parseInt(img[2]));
        // 暂时先把偏移量放在缓存里面，因前期只要移动就算，为后期如果要判断验证码的偏移量做准备
        String spm = request.getParameter("spm");
        String spmKey = MonitorRedisConstant.connectRedisKey(MonitorRedisConstant.redisKey,
                                                             MonitorRedisConstant.cheatSPM, spm);
        redisClient.setWithTimeAndDB(spmKey, vi.getMove().toString(), MonitorRedisConstant.EXPIRY_TIME,
                                     MonitorRedisConstant.DBINDEX);
        return vi;
    }

    /**
     * @description: 校验验证码
     * @param
     * @return
     */
    public Boolean validateCode(HttpServletRequest request) {
        // 暂时先把偏移量放在缓存里面，因前期只要移动就算，为后期如果要判断验证码的偏移量做准备
        String movex = request.getParameter("moveX");
        String spm = request.getParameter("spm");
        if (StringUtils.isEmpty(movex) || StringUtils.isEmpty("spm")) {
            return false;
        }
        String key = MonitorRedisConstant.connectRedisKey(MonitorRedisConstant.redisKey, MonitorRedisConstant.cheatSPM,
                                                          spm);
        String value = redisClient.get(key, MonitorRedisConstant.DBINDEX);
        // 校验验证码
        if (StringUtils.isNotEmpty(value) && Integer.parseInt(value) + 30 >= Integer.parseInt(movex)
            && Integer.parseInt(value) - 30 <= Integer.parseInt(movex)) {
            redisClient.setWithTimeAndDB(key, "10000", MonitorRedisConstant.EXPIRY_TIME, MonitorRedisConstant.DBINDEX);
        } else {
            return false;
        }
        return true;
    }

    /**
     * @description: 验证是否移动设备
     * @author: JandMin
     * @time: 2018/7/18 15:48
     * @param userAgent
     * @return boolean
     */
    private static boolean isMobileDevice(String userAgent) {
        if (null == userAgent) return false;
        /**
         * 所有android设备 : android mac os 排除苹果桌面系统Macintosh : iphone,ipad,ipod Nokia等windows系统的手机 : windows phone,windows
         * mobile 塞班系统 : symbianos 黑莓系统 : blackberry
         */
        String[] deviceArray = new String[] { "android", "iphone", "ipad", "ipod", "windows phone", "symbianos",
                                              "blackberry", "windows mobile" };
        userAgent = userAgent.toLowerCase();
        for (int i = 0; i < deviceArray.length; i++) {
            if (userAgent.indexOf(deviceArray[i]) != -1) {
                return true;
            }
        }
        return false;
    }

    // 获取验证码开始时间和结束时间
    public String getStartAndEndTime() {
        String key = MonitorRedisConstant.connectRedisKey(MonitorRedisConstant.redisKey, MonitorRedisConstant.dateTime);
        String value = redisClient.get(key, MonitorRedisConstant.DBINDEX);
        if (StringUtils.isBlank(value) || (StringUtils.isNotEmpty(value) && value.trim().split(",").length != 2)) {
            return null;
        }
        return value;
    }

    // 获取refer里面的spm参数
    public static String getSpmByRefer(HttpServletRequest request) {
        String refer = request.getHeader("Referer");
        String spm = null;
        List<String> s = Arrays.asList(refer.split("&"));
        for (String sp : s) {
            if (sp.indexOf("spm=lti") != -1) {
                spm = sp.split("=")[1];
                break;
            }
        }
        return spm;
    }

}
