/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.impl;

import com.alibaba.sec.client.FastIPGeoClient;
import com.alibaba.sec.exception.FastIPGeoException;
import com.alibaba.sec.license.exception.LicenseException;
import com.bxm.newidea.component.IpAddrInterface;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.entity.IpAddrDetails;
import com.bxm.newidea.component.impl.DescribeIpv4OnlineService;
import com.bxm.newidea.component.thread.NamedThreadFactory;
import com.bxm.newidea.component.utils.IpAddrUtils;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DescribeIpOnlineService
implements IpAddrInterface {
    private static final Logger log = LoggerFactory.getLogger(DescribeIpOnlineService.class);
    @Resource
    private DescribeIpv4OnlineService describeIpv4OnlineService;
    private AtomicBoolean initFlag = new AtomicBoolean(false);

    @Override
    public IpAddrDetails getIpAddrInfo(String ip) {
        if (this.initFlag.compareAndSet(false, true)) {
            this.init();
        }
        FastIPGeoClient defaultAcsClient = IpAddrUtils.getDefaultAcsClient();
        try {
            String search = defaultAcsClient.search(ip);
            return (IpAddrDetails)JSON.parseObject((String)search, IpAddrDetails.class);
        }
        catch (FastIPGeoException | LicenseException e) {
            log.error("\u963f\u91cc\u89e3\u6790\u5730\u5740\u5931\u8d25ip:{}", (Object)ip, (Object)e);
            return null;
        }
    }

    private void init() {
        this.describeIpv4OnlineService.updateIpData();
        ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("sync-alicloud-ip"));
        executorService.scheduleAtFixedRate(() -> this.describeIpv4OnlineService.updateIpData(), 0L, 30L, TimeUnit.MINUTES);
    }
}

