package com.bxm.newidea.component.runner;

import com.bxm.newidea.component.config.AlibabaIpProperties;
import com.bxm.newidea.component.impl.DescribeIpv4OnlineService;
import com.bxm.newidea.component.thread.NamedThreadFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author lowi
 * @date 2022/4/28 9:40
 */
@Component
public class IpUpdateRunner implements ApplicationRunner {

    @Resource
    private DescribeIpv4OnlineService describeIpv4OnlineService;

    @Resource
    private AlibabaIpProperties alibabaIpProperties;

    @Override
    public void run(ApplicationArguments args) throws Exception {

        if (alibabaIpProperties.getEnableUpdate()) {
            ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(1,
                    new NamedThreadFactory("sync-alicloud-ip"));
            executorService.scheduleAtFixedRate(() -> describeIpv4OnlineService.updateIpData(),
                    0,
                    30,
                    TimeUnit.MINUTES);
        } else {
            describeIpv4OnlineService.downloadOssConfigFile();
        }

    }
}
