package com.bxm.localnews.common.util;

import com.bxm.newidea.component.tools.StringUtils;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class HttpParamUtil {

    /**
     * paraName=paramValue,paramValue为空则忽略该参数
     * @param params
     * @param joiner
     * @param excludeParamNames
     * @return
     */
    public static String getSignStr(Map<String, String[]> params, String joiner, List<String> excludeParamNames) {
        String[] keyArr = params.keySet().toArray(new String[0]);
        Arrays.sort(keyArr);
        StringBuilder buf = new StringBuilder();
        for (String key : keyArr) {
            if (StringUtils.isNotEmpty(key)
                    && (excludeParamNames == null || !excludeParamNames.contains(key))) {
                if (buf.length() > 0) {
                    buf.append(joiner);
                }
                buf.append(key).append("=").append(params.get(key)[0]);
            }
        }
        return buf.toString();
    }

}
