package com.bxm.component.bus.annotations;

import com.bxm.component.bus.guava.AllowConcurrentEvents;

import java.lang.annotation.*;

/**
 * 事件总线监听器，代替默认的{@link com.google.common.eventbus.Subscribe}
 * 默认的监听注解，可能用在了历史业务中，防止出现冲突
 * 也为了明确调用者知道为何使用此注解，特进行定义
 * <p>
 * 此注解必须定义在public的方法上
 * <br/>
 * 推荐额外同时搭配{@link AllowConcurrentEvents}使用
 *
 * @author liujia
 * @date 12/2/21 4:09 PM
 **/
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface EventBusSubscriber {
}
