package com.bxm.newidea.component.sync.api;

import com.bxm.newidea.component.sync.core.CacheHolder;
import com.bxm.newidea.component.sync.vo.MonitorCacheVO;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 缓存监控Controller
 *
 * @author wzy
 * @version 1.0
 * @date 2020年12月17日23:58:55
 */
@RestController
@RequestMapping("/second/cache/monitor")
public class MonitorController {
    /**
     * 二级缓存Holder
     */
    private final CacheHolder holder;

    public MonitorController(CacheHolder holder) {
        this.holder = holder;
    }

    @GetMapping("up")
    public List<MonitorCacheVO> up() {
        return holder.getMonitorInfo();
    }
}