package com.bxm.newidea.component.sync.cluster;

import com.bxm.newidea.component.sync.constants.CommandTypeEnum;
import com.bxm.newidea.component.sync.key.DefaultCacheKeyGenerator;

/**
 * 集群通知策略接口(模板方法模式，模板定义好了，可以允许具体实现的算法)
 *
 * @author wzy
 * @date 2020年12月17日23:59:04
 */
public interface ClusterPolicy {

    /**
     * 广播通知类型
     *
     * @return 类型名称
     */
    String name();

    /**
     * 发送消息
     *
     * @param command 发送命令对象
     */
    void publish(Command command);

    /**
     * 发送清除缓存的命令
     *
     * @param keyGenerator 缓存名称
     * @param keys         缓存键值
     */
    default void sendEvictCmd(DefaultCacheKeyGenerator keyGenerator, String... keys) {
        publish(new Command(CommandTypeEnum.OPT_EVICT_KEY.getType(), keyGenerator, keys));
    }

    /**
     * 发送清除整个缓存区域的命令
     *
     * @param keyGenerator 缓存名称
     */
    default void sendClearCmd(DefaultCacheKeyGenerator keyGenerator) {
        publish(new Command(CommandTypeEnum.OPT_CLEAR_KEY.getType(), keyGenerator));
    }
}
