package com.bxm.newidea.component.sync.key;

import lombok.extern.slf4j.Slf4j;

/**
 * 默认二级缓存 Key实现(为了序列化和反序列化问题，暂时不适用抽象的keyGenerator)
 *
 * @author wzy
 * @date 2020年12月17日10:35:31
 */
@Slf4j
public class DefaultCacheKeyGenerator {

    /**
     * key 连接符
     */
    public static final String JOIN_CHAR = ":";

    /**
     * key最长的长度
     */
    public static final Integer MAX_KEY_LENGTH = 150;

    /**
     * 功能分组
     */
    String group;

    /**
     * cache key
     */
    String key;

    public DefaultCacheKeyGenerator(String group, String key) {
        this.group = group;
        this.key = key;
    }

    public static DefaultCacheKeyGenerator build(String group, String key) {
        return new DefaultCacheKeyGenerator(group, key);
    }

    public DefaultCacheKeyGenerator setGroup(String group) {
        this.group = group;
        return this;
    }

    public DefaultCacheKeyGenerator setKey(String key) {
        this.key = key;
        return this;
    }

    public String gen() {
        String bCacheKey = this.group + JOIN_CHAR + this.key;

        if (bCacheKey.length() > MAX_KEY_LENGTH) {
            log.warn("BCache缓存键值设计过长，请缩短实际保存的键，使用变量名来保证可阅读性,键：{}", bCacheKey);
        }
        return bCacheKey;
    }

    public String getGroup() {
        return group;
    }

    public String getKey() {
        return key;
    }

    @Override
    public String toString() {
        return gen();
    }
}
