/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.sync.api;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.component.sync.core.CacheHolder;
import com.bxm.newidea.component.sync.key.DefaultCacheKeyGenerator;
import com.bxm.newidea.component.sync.param.ClearParam;
import com.bxm.newidea.component.sync.param.EvictParam;
import com.bxm.newidea.component.vo.ResponseJson;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/second/cache/manage"})
@RestController
public class ManageCacheController {
    private final CacheHolder cacheHolder;

    public ManageCacheController(CacheHolder cacheHolder) {
        this.cacheHolder = cacheHolder;
    }

    @PostMapping(value={"evict"})
    public ResponseJson evict(@RequestBody EvictParam evictParam) {
        this.cacheHolder.evict(DefaultCacheKeyGenerator.build(evictParam.getGroupName(), evictParam.getKey()), evictParam.getSubKey());
        return ResponseJson.ok().build();
    }

    @PostMapping(value={"clear"})
    public ResponseJson clear(@RequestBody ClearParam param) {
        this.cacheHolder.clear(DefaultCacheKeyGenerator.build(param.getGroupName(), param.getKey()));
        return ResponseJson.ok().build();
    }

    @PostMapping(value={"clearGroup"})
    public ResponseJson clearGroup(@RequestBody ClearParam param) {
        this.cacheHolder.clearGroup(param.getGroupName());
        return ResponseJson.ok().build();
    }

    @GetMapping(value={"allGroup"})
    public ResponseJson<List<String>> getAllGroup() {
        return ResponseJson.ok(this.cacheHolder.getAllGroup());
    }

    @GetMapping(value={"{group}/{key}/{subKey}"})
    public ResponseJson<String> get(@PathVariable String group, @PathVariable String key, @PathVariable String subKey) {
        Object object = this.cacheHolder.get(DefaultCacheKeyGenerator.build(group, key), subKey);
        if (null == object) {
            return ResponseJson.ok((Object)"null");
        }
        return ResponseJson.ok((Object)JSON.toJSONString(object));
    }
}

