/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.sync.core;

import com.bxm.newidea.component.sync.cluster.ClusterPolicy;
import com.bxm.newidea.component.sync.cluster.DefaultClusterPolicy;
import com.bxm.newidea.component.sync.config.SecondLevelCacheConfig;
import com.bxm.newidea.component.sync.factory.CacheProviderFactory;
import com.bxm.newidea.component.sync.key.DefaultCacheKeyGenerator;
import com.bxm.newidea.component.sync.provider.CacheProvider;
import com.bxm.newidea.component.sync.vo.MonitorCacheVO;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.springframework.stereotype.Component;

@Component
public class CacheHolder {
    private CacheProvider cacheProvider;
    private ClusterPolicy clusterPolicy = new DefaultClusterPolicy();

    public CacheHolder(SecondLevelCacheConfig secondLevelCacheConfig, List<ClusterPolicy> policyList) {
        this.cacheProvider = CacheProviderFactory.getProviderInstance(secondLevelCacheConfig.getCacheIndent());
        for (ClusterPolicy policyItem : policyList) {
            if (!StringUtils.equals((CharSequence)policyItem.name(), (CharSequence)secondLevelCacheConfig.getBroadcast())) continue;
            this.clusterPolicy = policyItem;
            break;
        }
    }

    public <R> void set(DefaultCacheKeyGenerator keyGenerator, Function<String, R> cacheLoader) {
        this.cacheProvider.set(keyGenerator, cacheLoader);
    }

    public <R> void set(DefaultCacheKeyGenerator keyGenerator, Function<String, R> cacheLoader, long maximumSize, TimeUnit timeUnit, long duration) {
        this.cacheProvider.set(keyGenerator, cacheLoader, maximumSize, timeUnit, duration);
    }

    public <R> void set(DefaultCacheKeyGenerator keyGenerator, Function<String, R> cacheLoader, long maximumSize) {
        this.cacheProvider.set(keyGenerator, cacheLoader, maximumSize);
    }

    public <V> Map<String, V> get(DefaultCacheKeyGenerator keyGenerator, Collection<String> subKeys) {
        return this.cacheProvider.get(keyGenerator, subKeys);
    }

    public <V> V get(DefaultCacheKeyGenerator keyGenerator, String subKey) {
        return this.cacheProvider.get(keyGenerator, subKey);
    }

    public <V> void set(DefaultCacheKeyGenerator keyGenerator, String subKey, V value) {
        this.cacheProvider.set(keyGenerator, subKey, value);
    }

    public boolean exists(DefaultCacheKeyGenerator keyGenerator, String subKey) {
        return this.cacheProvider.exists(keyGenerator, subKey);
    }

    public boolean existsCache(DefaultCacheKeyGenerator keyGenerator) {
        return this.cacheProvider.existsCache(keyGenerator);
    }

    public <V> void set(DefaultCacheKeyGenerator keyGenerator, Map<String, V> elements) {
        this.cacheProvider.set(keyGenerator, elements);
    }

    public Collection<String> subKeys(DefaultCacheKeyGenerator keyGenerator) {
        return this.cacheProvider.subKeys(keyGenerator);
    }

    public void evict(DefaultCacheKeyGenerator keyGenerator, String ... subKeys) {
        this.cacheProvider.evict(keyGenerator, subKeys);
    }

    public void clear(DefaultCacheKeyGenerator keyGenerator) {
        this.cacheProvider.clear(keyGenerator);
    }

    public void sendEvictCmd(DefaultCacheKeyGenerator keyGenerator, String ... keys) {
        this.clusterPolicy.sendEvictCmd(keyGenerator, keys);
    }

    public void sendClearCmd(DefaultCacheKeyGenerator keyGenerator) {
        this.clusterPolicy.sendClearCmd(keyGenerator);
    }

    public void clearGroup(String groupName) {
        this.cacheProvider.clearGroup(groupName);
    }

    public List<String> getAllGroup() {
        return this.cacheProvider.getAllGroup();
    }

    public List<MonitorCacheVO> getMonitorInfo() {
        return this.cacheProvider.getMonitorInfo();
    }
}

