/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.sync.listener;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.component.sync.cluster.Command;
import com.bxm.newidea.component.sync.config.SecondLevelCacheConfig;
import com.bxm.newidea.component.sync.constants.CommandTypeEnum;
import com.bxm.newidea.component.sync.core.CacheHolder;
import com.bxm.newidea.component.sync.key.DefaultCacheKeyGenerator;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.bus.event.EnvironmentChangeRemoteApplicationEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class SecondLevelCacheListener {
    private static final Logger log = LoggerFactory.getLogger(SecondLevelCacheListener.class);
    @Resource
    private SecondLevelCacheConfig secondLevelCacheConfig;
    private final CacheHolder cacheHolder;

    public SecondLevelCacheListener(CacheHolder cacheHolder) {
        this.cacheHolder = cacheHolder;
    }

    @EventListener
    public void onEnvironmentChangeRemoteApplicationEvent(EnvironmentChangeRemoteApplicationEvent event) {
        Map eventMap = event.getValues();
        log.info("Received Bus event content: {}", (Object)eventMap);
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)eventMap.get(this.secondLevelCacheConfig.getEnvName())))) {
            String command = (String)eventMap.get(this.secondLevelCacheConfig.getEnvName());
            log.info("Received Bus event command: {}", (Object)command);
            if (StringUtils.isNotBlank((CharSequence)command)) {
                log.info("SpringCloudBus Second Level Cache notice command info: {} ", (Object)command);
                Command refreshCommand = (Command)JSON.parseObject((String)command, Command.class);
                this.executeCommand(refreshCommand);
            }
        }
        log.info(" Source : {} , originService : {} , destinationService : {} \n", new Object[]{event.getSource(), event.getOriginService(), event.getDestinationService()});
    }

    public void executeCommand(Command targetCommand) {
        DefaultCacheKeyGenerator refreshKeyGenerator = targetCommand.getKeyGenerator();
        if (this.cacheHolder.existsCache(refreshKeyGenerator)) {
            if (targetCommand.getOperator() == CommandTypeEnum.OPT_EVICT_KEY.getType()) {
                for (String commandKey : targetCommand.getKeys()) {
                    if (!this.cacheHolder.exists(refreshKeyGenerator, commandKey)) continue;
                    this.cacheHolder.evict(refreshKeyGenerator, commandKey);
                }
            } else if (targetCommand.getOperator() == CommandTypeEnum.OPT_CLEAR_KEY.getType()) {
                this.cacheHolder.clear(refreshKeyGenerator);
            }
        }
    }
}

