/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.sync.provider.guava;

import com.bxm.newidea.component.sync.key.DefaultCacheKeyGenerator;
import com.bxm.newidea.component.sync.provider.CacheProvider;
import com.bxm.newidea.component.sync.vo.MonitorCacheVO;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class GuavaLoaderProvider
implements CacheProvider {
    private Map<String, LoadingCache> caches = new ConcurrentHashMap<String, LoadingCache>();

    public <T, R> LoadingCache<T, R> newGuavaCache(CacheLoader<T, R> cacheLoader, long maximumSize, TimeUnit timeUnit, long duration) {
        return CacheBuilder.newBuilder().recordStats().maximumSize(maximumSize).expireAfterWrite(duration, timeUnit).build(cacheLoader);
    }

    public <T, R> LoadingCache<T, R> newGuavaCache(CacheLoader<T, R> cacheLoader) {
        return CacheBuilder.newBuilder().recordStats().build(cacheLoader);
    }

    @Override
    public <T, R> void set(DefaultCacheKeyGenerator keyGenerator, final Function<T, R> cacheLoader) {
        this.caches.computeIfAbsent(keyGenerator.gen(), v -> this.newGuavaCache(new CacheLoader<T, R>(){

            public R load(T key) throws Exception {
                return cacheLoader.apply(key);
            }
        }));
    }

    @Override
    public <T, R> void set(DefaultCacheKeyGenerator keyGenerator, final Function<T, R> cacheLoader, long maximumSize, TimeUnit timeUnit, long duration) {
        this.caches.computeIfAbsent(keyGenerator.gen(), v -> this.newGuavaCache(new CacheLoader<T, R>(){

            public R load(T key) throws Exception {
                return cacheLoader.apply(key);
            }
        }, maximumSize, timeUnit, duration));
    }

    @Override
    public <T, R> void set(DefaultCacheKeyGenerator keyGenerator, final Function<T, R> cacheLoader, long maximumSize) {
        this.caches.computeIfAbsent(keyGenerator.gen(), v -> this.newGuavaCache(new CacheLoader<T, R>(){

            public R load(T key) throws Exception {
                return cacheLoader.apply(key);
            }
        }, maximumSize, TimeUnit.SECONDS, 1800L));
    }

    @Override
    public <K, V> Map<K, V> get(DefaultCacheKeyGenerator keyGenerator, Collection<K> subKeys) {
        LoadingCache loadingCache = this.caches.get(keyGenerator.gen());
        if (Objects.isNull(loadingCache)) {
            return null;
        }
        return loadingCache.getAllPresent(subKeys);
    }

    @Override
    public <K, V> V get(DefaultCacheKeyGenerator keyGenerator, K subKey) {
        LoadingCache loadingCache = this.caches.get(keyGenerator.gen());
        if (Objects.isNull(loadingCache)) {
            return null;
        }
        return (V)loadingCache.getUnchecked(subKey);
    }

    @Override
    public <K, V> void set(DefaultCacheKeyGenerator keyGenerator, K subKey, V value) {
        LoadingCache loadingCache = this.caches.get(keyGenerator.gen());
        if (Objects.isNull(loadingCache)) {
            return;
        }
        loadingCache.put(subKey, value);
    }

    @Override
    public <K, V> boolean exists(DefaultCacheKeyGenerator keyGenerator, K subKey) {
        LoadingCache loadingCache = this.caches.get(keyGenerator.gen());
        if (Objects.isNull(loadingCache)) {
            return false;
        }
        return Objects.nonNull(loadingCache.getIfPresent(subKey));
    }

    @Override
    public <K, V> void set(DefaultCacheKeyGenerator keyGenerator, Map<K, V> elements) {
        LoadingCache loadingCache = this.caches.get(keyGenerator.gen());
        if (Objects.isNull(loadingCache)) {
            return;
        }
        loadingCache.putAll(elements);
    }

    @Override
    public <K, V> Collection<K> subKeys(DefaultCacheKeyGenerator keyGenerator) {
        LoadingCache loadingCache = this.caches.get(keyGenerator.gen());
        if (Objects.isNull(loadingCache)) {
            return Collections.emptyList();
        }
        return loadingCache.asMap().keySet();
    }

    @Override
    public <K, V> void evict(DefaultCacheKeyGenerator keyGenerator, K ... subKeys) {
        LoadingCache loadingCache = this.caches.get(keyGenerator.gen());
        if (Objects.isNull(loadingCache)) {
            return;
        }
        loadingCache.invalidateAll(Arrays.asList(subKeys));
    }

    @Override
    public <K, V> void clear(DefaultCacheKeyGenerator keyGenerator) {
        LoadingCache loadingCache = this.caches.get(keyGenerator.gen());
        if (Objects.isNull(loadingCache)) {
            return;
        }
        loadingCache.invalidateAll();
    }

    @Override
    public boolean existsCache(DefaultCacheKeyGenerator keyGenerator) {
        return Objects.nonNull(keyGenerator);
    }

    @Override
    public List<MonitorCacheVO> getMonitorInfo() {
        ArrayList<MonitorCacheVO> monitorCacheVOList = new ArrayList<MonitorCacheVO>();
        this.caches.forEach((k, v) -> {
            CacheStats cacheStats = v.stats();
            MonitorCacheVO cacheVO = new MonitorCacheVO();
            cacheVO.setCacheName((String)k);
            cacheVO.setHintCount(cacheStats.hitCount());
            cacheVO.setMissCount(cacheStats.missCount());
            cacheVO.setHintRate(cacheStats.hitRate());
            cacheVO.setEvictionCount(cacheStats.evictionCount());
            cacheVO.setLoadSuccessCount(cacheStats.loadExceptionCount());
            cacheVO.setLoadExceptionCount(cacheStats.loadSuccessCount());
            cacheVO.setTotalLoadTime(cacheStats.totalLoadTime());
            cacheVO.setRequestCount(cacheStats.requestCount());
            cacheVO.setSize(v.size());
            monitorCacheVOList.add(cacheVO);
        });
        return monitorCacheVOList;
    }

    @Override
    public void clearGroup(String groupName) {
        this.caches.forEach((k, v) -> {
            String[] keys = k.split(":");
            String targetGroupName = keys[0];
            if (Objects.equals(targetGroupName, groupName)) {
                v.invalidateAll();
            }
        });
    }

    @Override
    public List<String> getAllGroup() {
        HashSet groupNameSet = new HashSet();
        this.caches.forEach((k, v) -> {
            String[] keys = k.split(":");
            String targetGroupName = keys[0];
            groupNameSet.add(targetGroupName);
        });
        ArrayList<String> resultList = new ArrayList<String>(groupNameSet);
        resultList.sort(String::compareTo);
        return resultList;
    }
}

