package com.bxm.newidea.component.sync.cluster;


import com.bxm.newidea.component.sync.key.CacheKeyGenerator;

/**
 * 缓存失效命令包装类
 *
 * @author wzy
 * @version 1.0
 * @date 2020年12月17日23:59:11
 */
public class Command {
    /**
     * 操作类型（是清除整个缓存还是清除某个缓存的某个key值）
     */
    private int operator;

    /**
     * 缓存key
     */
    private CacheKeyGenerator keyGenerator;

    /**
     * 要清除具体缓存keys列表
     */
    private String[] keys;

    public Command(int operator, CacheKeyGenerator keyGenerator, String[] keys) {
        this.operator = operator;
        this.keyGenerator = keyGenerator;
        this.keys = keys;
    }

    public Command(int operator, CacheKeyGenerator keyGenerator) {
        this.operator = operator;
        this.keyGenerator = keyGenerator;
    }

    public int getOperator() {
        return operator;
    }


    public CacheKeyGenerator getKeyGenerator() {
        return keyGenerator;
    }


    public String[] getKeys() {
        return keys;
    }

}