package com.bxm.newidea.component.sync.cluster;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.component.sync.config.SecondLevelCacheConfig;
import lombok.extern.slf4j.Slf4j;
import okhttp3.*;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.validation.constraints.NotNull;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * RabbitMQ集群通知策略实现类
 *
 * @author wzy
 * @date 2020年12月17日23:59:16
 */
@Slf4j
@Component
public class RabbitmqClusterPolicy implements ClusterPolicy {

    private final SecondLevelCacheConfig secondLevelCacheConfig;

    /**
     * 应用端口号
     */
    @Value("${server.port}")
    private String port;

    public RabbitmqClusterPolicy(SecondLevelCacheConfig secondLevelCacheConfig) {
        this.secondLevelCacheConfig = secondLevelCacheConfig;
    }


    @Override
    public String name() {
        return "rabbitmq";
    }

    @Override
    public void publish(Command command) {
        // 使用Spring Cloud Bus消息总线发送更新缓存消息，通过访问env接口去发送事件发送缓存变动消息
        String envUrl = secondLevelCacheConfig.getEnvTemplateUrl();

        envUrl = String.format(envUrl, port);

        OkHttpClient client = new OkHttpClient();

        Call call = client.newCall(buildNotifyParam(envUrl, command));

        call.enqueue(new Callback() {
            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                log.error(e.getMessage());
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                String result = response.body().string();
                log.info("info: {}", result);
            }
        });
    }

    private Request buildNotifyParam(String envUrl, Command command) {
        MediaType jsonType = MediaType.parse("application/json; charset=utf-8");

        Map<String, String> params = new HashMap<>();
        params.put("name", secondLevelCacheConfig.getEnvName());
        params.put("value", JSON.toJSONString(command));

        RequestBody requestBody = RequestBody.create(jsonType, JSON.toJSONString(params));
        //创建一个请求对象
        return new Request.Builder()
                .url(envUrl)
                .post(requestBody)
                .build();
    }
}
