package com.bxm.newidea.component.sync.vo;

import lombok.Data;

/**
 * 缓存统计信息
 *
 * @author wzy
 * @version 1.0
 * @date 2020/9/24 3:33 下午
 */
@Data
public class MonitorCacheVO {
    /**
     * 缓存名称
     */
    private String cacheName;
    /**
     * 余量
     */
    private Long size;

    /**
     * 命中率
     */
    private Double hintRate;

    /**
     * 命中次数
     */
    private Long hintCount;

    /**
     * 请求总次数
     */
    private Long requestCount;

    /**
     * 未命中缓存数量
     */
    private Long missCount;

    /**
     * 成功加载新值的次数
     */
    private Long loadSuccessCount;

    /**
     * 失败加载新值的次数
     */
    private Long loadExceptionCount;

    /**
     * 缓存总共加载时间
     */
    private Long totalLoadTime;

    /**
     * 丢失的条数(超出缓存最大的容量就会丢失)
     */
    private Long evictionCount;


    @Override
    public String toString() {
        return "MonitorCacheVO{" +
                "cacheName='" + cacheName + '\'' +
                ", size=" + size +
                ", hintRate=" + hintRate +
                ", hintCount=" + hintCount +
                ", requestCount=" + requestCount +
                ", missCount=" + missCount +
                ", loadSuccessCount=" + loadSuccessCount +
                ", loadExceptionCount=" + loadExceptionCount +
                ", totalLoadTime=" + totalLoadTime +
                ", evictionCount=" + evictionCount +
                '}';
    }
}