/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.sync.cluster;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.component.sync.cluster.ClusterPolicy;
import com.bxm.newidea.component.sync.cluster.Command;
import com.bxm.newidea.component.sync.config.SecondLevelCacheConfig;
import java.io.IOException;
import java.util.HashMap;
import javax.validation.constraints.NotNull;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class RabbitmqClusterPolicy
implements ClusterPolicy {
    private static final Logger log = LoggerFactory.getLogger(RabbitmqClusterPolicy.class);
    private final SecondLevelCacheConfig secondLevelCacheConfig;
    @Value(value="${server.port}")
    private String port;

    public RabbitmqClusterPolicy(SecondLevelCacheConfig secondLevelCacheConfig) {
        this.secondLevelCacheConfig = secondLevelCacheConfig;
    }

    @Override
    public String name() {
        return "rabbitmq";
    }

    @Override
    public void publish(Command command) {
        String envUrl = this.secondLevelCacheConfig.getEnvTemplateUrl();
        envUrl = String.format(envUrl, this.port);
        OkHttpClient client = new OkHttpClient();
        Call call = client.newCall(this.buildNotifyParam(envUrl, command));
        call.enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                log.error(e.getMessage());
            }

            public void onResponse(Call call, Response response) throws IOException {
                String result = response.body().string();
                log.info("info: {}", (Object)result);
            }
        });
    }

    private Request buildNotifyParam(String envUrl, Command command) {
        MediaType jsonType = MediaType.parse((String)"application/json; charset=utf-8");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", this.secondLevelCacheConfig.getEnvName());
        params.put("value", JSON.toJSONString((Object)command));
        RequestBody requestBody = RequestBody.create((MediaType)jsonType, (String)JSON.toJSONString(params));
        return new Request.Builder().url(envUrl).post(requestBody).build();
    }
}

