/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.sync.core;

import com.bxm.newidea.component.sync.cluster.ClusterPolicy;
import com.bxm.newidea.component.sync.config.SecondLevelCacheConfig;
import com.bxm.newidea.component.sync.factory.CacheProviderFactory;
import com.bxm.newidea.component.sync.key.CacheKeyGenerator;
import com.bxm.newidea.component.sync.provider.CacheProvider;
import com.bxm.newidea.component.sync.vo.MonitorCacheVO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class CacheHolder {
    @Resource
    private SecondLevelCacheConfig secondLevelCacheConfig;
    @Resource
    private CacheProvider cacheProvider;
    private ClusterPolicy clusterPolicy;

    public CacheHolder(SecondLevelCacheConfig secondLevelCacheConfig, List<ClusterPolicy> policyList) {
        this.cacheProvider = CacheProviderFactory.getProviderInstance(secondLevelCacheConfig.getCacheIndent());
        for (ClusterPolicy policyItem : policyList) {
            if (!policyItem.name().equals(secondLevelCacheConfig.getBroadcast())) continue;
            this.clusterPolicy = policyItem;
            break;
        }
    }

    public <T, R> void set(CacheKeyGenerator keyGenerator, Function<T, R> cacheLoader) {
        this.cacheProvider.set(keyGenerator, cacheLoader);
    }

    public <T, R> void set(CacheKeyGenerator keyGenerator, Function<T, R> cacheLoader, long maximumSize, TimeUnit timeUnit, long duration) {
        this.cacheProvider.set(keyGenerator, cacheLoader, maximumSize, timeUnit, duration);
    }

    public <T, R> void set(CacheKeyGenerator keyGenerator, Function<T, R> cacheLoader, long maximumSize) {
        this.cacheProvider.set(keyGenerator, cacheLoader, maximumSize);
    }

    public Map<String, Object> get(CacheKeyGenerator keyGenerator, Collection<String> subKeys) {
        return this.cacheProvider.get(keyGenerator, subKeys);
    }

    public Object get(CacheKeyGenerator keyGenerator, String subKey) {
        return this.cacheProvider.get(keyGenerator, subKey);
    }

    public void set(CacheKeyGenerator keyGenerator, String subKey, Object value) {
        this.cacheProvider.set(keyGenerator, subKey, value);
    }

    public boolean exists(CacheKeyGenerator keyGenerator, String subKey) {
        return this.cacheProvider.exists(keyGenerator, subKey);
    }

    public boolean existsCache(CacheKeyGenerator keyGenerator) {
        return this.cacheProvider.existsCache(keyGenerator);
    }

    public void set(CacheKeyGenerator keyGenerator, Map<String, Object> elements) {
        this.cacheProvider.set(keyGenerator, elements);
    }

    public Collection<String> subKeys(CacheKeyGenerator keyGenerator) {
        return this.cacheProvider.subKeys(keyGenerator);
    }

    public void evict(CacheKeyGenerator keyGenerator, String ... subKeys) {
        this.cacheProvider.evict(keyGenerator, subKeys);
    }

    public void clear(CacheKeyGenerator keyGenerator) {
        this.cacheProvider.clear(keyGenerator);
    }

    public void sendEvictCmd(CacheKeyGenerator keyGenerator, String ... keys) {
        this.clusterPolicy.sendEvictCmd(keyGenerator, keys);
    }

    public void sendClearCmd(CacheKeyGenerator keyGenerator) {
        this.clusterPolicy.sendClearCmd(keyGenerator);
    }

    public List<MonitorCacheVO> getMonitorInfo() {
        return this.cacheProvider.getMonitorInfo();
    }
}

