package com.bxm.newidea.component.sync.cluster;


import com.bxm.newidea.component.sync.key.SyncCacheKey;
import lombok.Data;
import lombok.ToString;

/**
 * 缓存失效命令包装类
 *
 * @author wzy
 * @version 1.0
 * @date 2020年12月17日23:59:11
 */
@ToString
@Data
public class Command {
    /**
     * 操作类型（是清除整个缓存还是清除某个缓存的某个key值）
     */
    private int operator;

    /**
     * 缓存key
     */
    private SyncCacheKey keyGenerator;

    /**
     * 要清除具体缓存keys列表
     * 存储键值对应的hashcode
     */
    private Integer[] keys;

    public <T> Command(int operator, SyncCacheKey keyGenerator, T[] keys) {
        this.operator = operator;
        this.keyGenerator = keyGenerator;

        this.keys = new Integer[keys.length];
        for (int i = 0; i < keys.length; i++) {
            this.keys[i] = keys[i].hashCode();
        }
    }

    public Command(int operator, SyncCacheKey keyGenerator) {
        this.operator = operator;
        this.keyGenerator = keyGenerator;
    }

    public Command() {
    }

    public int getOperator() {
        return operator;
    }


    public SyncCacheKey getKeyGenerator() {
        return keyGenerator;
    }


    public Integer[] getKeys() {
        return keys;
    }

}