package com.bxm.newidea.component.sync.cluster;

import com.bxm.newidea.component.sync.constants.CommandTypeEnum;
import com.bxm.newidea.component.sync.core.CacheHolder;
import com.bxm.newidea.component.sync.core.SyncCacheHolderFactory;
import com.bxm.newidea.component.sync.key.SyncCacheKey;
import lombok.extern.slf4j.Slf4j;

/**
 * @author liujia
 * @date 10/27/21 8:21 PM
 **/
@Slf4j
public class CommandExecutor {

    /**
     * 执行缓存通知命令
     *
     * @param targetCommand 要执行的目标命令
     */
    public void executeCommand(Command targetCommand) {
        if (log.isDebugEnabled()) {
            log.debug("执行命令：{}", targetCommand);
        }
        CacheHolder cacheHolder = SyncCacheHolderFactory.getCacheHolder();

        SyncCacheKey refreshKeyGenerator = targetCommand.getKeyGenerator();

        //首先判断是否存在这个缓存
        if (cacheHolder.existsCache(refreshKeyGenerator)) {
            if (targetCommand.getOperator() == CommandTypeEnum.OPT_EVICT_KEY.getType()) {
                for (Integer commandKey : targetCommand.getKeys()) {
                    if (cacheHolder.exists(refreshKeyGenerator, commandKey)) {
                        cacheHolder.evict(refreshKeyGenerator, commandKey);
                    }
                }
            } else if (targetCommand.getOperator() == CommandTypeEnum.OPT_CLEAR_KEY.getType()) {
                cacheHolder.clear(refreshKeyGenerator);
            }
        }
    }
}
