package com.bxm.newidea.component.sync.cluster;

import com.bxm.newidea.component.JSON;
import lombok.experimental.UtilityClass;
import lombok.extern.slf4j.Slf4j;
import okhttp3.*;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.jetbrains.annotations.NotNull;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;

/**
 * 内部调用，缩短超时时间
 *
 * @author liujia
 * @date 10/27/21 10:36 PM
 **/
@UtilityClass
@Slf4j
public class FastOkHttpUtils {
    public static OkHttpClient singleton;

    static {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(200L, TimeUnit.MILLISECONDS);
        builder.readTimeout(1L, TimeUnit.SECONDS);
        builder.writeTimeout(1L, TimeUnit.SECONDS);
        ConnectionPool connectionPool = new ConnectionPool(5, 30, TimeUnit.SECONDS);
        builder.connectionPool(connectionPool);
        singleton = builder.build();
    }

    public static <T> void postJson(String url, T body) throws URISyntaxException, IOException {
        String content = JSON.toJSONString(body);

        URIBuilder uriBuilder = new URIBuilder(url);

        Request request = new Request.Builder()
                .addHeader("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:0.9.4)")
                .url(uriBuilder.toString())
                .post(RequestBody.create(content, MediaType.parse(String.valueOf(ContentType.APPLICATION_JSON))))
                .build();

        singleton.newCall(request).enqueue(new Callback() {
            @Override
            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                log.info("[{}]调用失败，错误：{}", call.request().url(), e.getMessage());
            }

            @Override
            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                if (!response.isSuccessful()) {
                    log.debug("[{}]调用失败，响应状态:{},返回结果：{}",
                            call.request().url(),
                            response.code(),
                            response.message());
                }
                response.close();
            }
        });
    }
}
