package com.bxm.newidea.component.sync.cluster.springcloudbus;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.sync.cluster.Command;
import com.bxm.newidea.component.sync.cluster.CommandExecutor;
import com.bxm.newidea.component.sync.config.MemoryCacheConfigurationProperties;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.bus.event.EnvironmentChangeRemoteApplicationEvent;
import org.springframework.context.event.EventListener;

import java.util.Map;

/**
 * 监听spring cloud 刷新消息总线
 *
 * @author wzy
 * @version 1.0
 * @date 2020/10/20 3:40 下午
 */
@Slf4j
public class SecondLevelCacheListener {

    private MemoryCacheConfigurationProperties properties;

    private CommandExecutor commandExecutor;

    public SecondLevelCacheListener(MemoryCacheConfigurationProperties properties, CommandExecutor commandExecutor) {
        this.properties = properties;
        this.commandExecutor = commandExecutor;
    }

    /**
     * 监听当有新的消息时触发的事件
     *
     * @param event 事件对象
     */
    @EventListener
    public void onEnvironmentChangeRemoteApplicationEvent(EnvironmentChangeRemoteApplicationEvent event) {
        // 监听到修改缓存值的消息
        Map<String, String> eventMap = event.getValues();

        if (StringUtils.isNotBlank(eventMap.get(properties.getEnvName()))) {
            String command = eventMap.get(properties.getEnvName());

            //将命令反序列化
            if (StringUtils.isNotBlank(command)) {
                Command refreshCommand = JSON.parseObject(command, Command.class);
                if (null != refreshCommand) {
                    commandExecutor.executeCommand(refreshCommand);
                }
            }
        }
    }


}