package com.bxm.newidea.component.sync.config;

import com.bxm.newidea.component.sync.cluster.ClusterPolicy;
import com.bxm.newidea.component.sync.cluster.CommandExecutor;
import com.bxm.newidea.component.sync.cluster.DefaultClusterPolicy;
import com.bxm.newidea.component.sync.core.CacheHolder;
import com.bxm.newidea.component.tools.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.List;

/**
 * 二级缓存同步组件的装配
 *
 * @author liujia
 * @date 1/22/21 10:10 AM
 **/
@Slf4j
@Configuration(proxyBeanMethods = false)
@EnableConfigurationProperties(MemoryCacheConfigurationProperties.class)
public class CacheSyncAutoConfiguration {

    private MemoryCacheConfigurationProperties properties;

    public CacheSyncAutoConfiguration(MemoryCacheConfigurationProperties properties) {
        this.properties = properties;
    }

    @Bean
    public CacheHolder cacheHolder(List<ClusterPolicy> clusterPolicies) {
        ClusterPolicy matchClusterPolicy = new DefaultClusterPolicy();

        for (ClusterPolicy clusterPolicy : clusterPolicies) {
            if (StringUtils.equals(clusterPolicy.name(), properties.getEventBroadcast())) {
                matchClusterPolicy = clusterPolicy;
                break;
            }
        }

        log.info("缓存的广播策略为：{}", matchClusterPolicy);

        return new CacheHolder(properties, matchClusterPolicy);
    }

    @Bean
    public CommandExecutor commandExecutor() {
        return new CommandExecutor();
    }
}
