package com.bxm.newidea.component.sync.config;

import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * BCache配置文件读取
 *
 * @author wzy
 * @date 2020年12月18日11:51:31
 */
@Data
@ConfigurationProperties("second.level.config")
public class MemoryCacheConfigurationProperties {

    /**
     * 二级缓存类型，默认guava
     */
    private String cacheIndent = "guava";

    /**
     * 缓存发生变更，需要在多实例之间广播的时候，使用的广播方式。默认为当前实例进行广播
     * 可选值：
     * springCloudEventBus : 基于spring cloud bus实现的通知机制，需要服务引用消息同一个消息队列
     * nacos : 根据nacos注册的服务实例进行广播
     */
    private String eventBroadcast = "nacos";

    /**
     * 事件发送模板url
     */
    private String envTemplateUrl = "http://localhost:%s%s/actuator/bus-env";

    /**
     * 缓存更改事件名称
     */
    private String envName = "secondLevelCache";

    /**
     * 引用当前组件的服务名称
     */
    @Value("${spring.application.name}")
    private String appName;

    @Value("${server.port}")
    private Integer serverPort;
}
