package com.bxm.newidea.component.sync.config;

import com.alibaba.cloud.nacos.discovery.NacosDiscoveryAutoConfiguration;
import com.alibaba.cloud.nacos.discovery.NacosServiceDiscovery;
import com.bxm.newidea.component.sync.cluster.Command;
import com.bxm.newidea.component.sync.cluster.CommandExecutor;
import com.bxm.newidea.component.sync.cluster.nacos.NacosClusterPolicy;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Configuration
@AutoConfigureAfter({NacosDiscoveryAutoConfiguration.class})
@ConditionalOnBean(NacosServiceDiscovery.class)
@ConditionalOnProperty(prefix = "second.level.config", name = "eventBroadcast", havingValue = "nacos", matchIfMissing = true)
@EnableConfigurationProperties(MemoryCacheConfigurationProperties.class)
@Slf4j
public class SyncCacheNacosAutoConfiguration {

    private MemoryCacheConfigurationProperties properties;

    public SyncCacheNacosAutoConfiguration(MemoryCacheConfigurationProperties properties) {
        this.properties = properties;
    }

    @Bean
    public NacosClusterPolicy nacosClusterPolicy(NacosServiceDiscovery nacosServiceDiscovery, CommandExecutor commandExecutor) {
        return new NacosClusterPolicy(properties, nacosServiceDiscovery, commandExecutor);
    }

    /**
     * nacos广播策略的暴露API，用于广播时的回调，进行相关缓存的清除操作
     *
     * @author liujia
     * @date 10/27/21 8:04 PM
     **/
    @RestController
    @RequestMapping("/expose/nacos/cache")
    @AllArgsConstructor
    public class NacosClusterPolicyExpose {

        private CommandExecutor commandExecutor;

        @PostMapping
        public Boolean clear(@RequestBody Command command) {
            if (log.isDebugEnabled()) {
                log.debug("执行nacos远程清理命令：{}", command);
            }

            commandExecutor.executeCommand(command);
            return true;
        }
    }
}



