package com.bxm.newidea.component.sync.core;

import com.bxm.newidea.component.sync.key.SyncCacheKey;

/**
 * @author liujia
 * @date 10/27/21 9:27 PM
 **/
public class SyncCacheAgent<T, R> {
    private CacheHolder cacheHolder;

    private SyncCacheKey cacheKey;

    SyncCacheAgent(SyncCacheKey cacheKey, CacheHolder cacheHolder) {
        this.cacheKey = cacheKey;
        this.cacheHolder = cacheHolder;
    }

    public void put(T subKey, R data) {
        cacheHolder.set(cacheKey, subKey, data);
    }

    /**
     * 查询键值
     *
     * @param subKey 指定缓存中的子健
     * @return 子健对应的值
     */
    public R get(T subKey) {
        return cacheHolder.get(cacheKey, subKey);
    }

    /**
     * 将某一些缓存设置为过期,并广播
     *
     * @param keys 过期的键值
     */
    public <T> void sendEvictCmd(T... keys) {
        cacheHolder.sendEvictCmd(cacheKey, keys);
    }

    /**
     * 清除缓存,并广播
     */
    public void sendClearCmd() {
        cacheHolder.sendClearCmd(cacheKey);
    }

    /**
     * 清除当前分组，慎用
     */
    public void clearCurrentGroup() {
        cacheHolder.clearGroup(cacheKey.getGroup());
    }

    public CacheHolder getCacheHolder() {
        return this.cacheHolder;
    }
}
